#include<bits/stdc++.h>

using namespace std;

struct Tacka 
{
    long long x, y;
    Tacka(long long x = 0, long long y = 0) : x(x), y(y) {}
    
    Tacka operator-(const Tacka& p) const 
    {
        return Tacka(x - p.x, y - p.y);
    }
    
    bool operator<(const Tacka& p) const 
    {
        return x < p.x || (x == p.x && y < p.y);
    }
};

inline long long proizvod(const Tacka& a, const Tacka& b) 
{
    return a.x * b.y - a.y * b.x;
}

inline double Povrsina(const vector<Tacka>& tacke) 
{
    const int n = tacke.size();
    long long povrsina = 0;
    for (int i = 0, j = n - 1; i < n; j = i++) povrsina += proizvod(tacke[i], tacke[j]);
    return abs(povrsina) / 2.0;
}


vector<Tacka> konveksniOmotac(vector<Tacka>& tacke) {
    const int n = tacke.size();
    if (n <= 3) return tacke;

    sort(tacke.begin(), tacke.end());
    vector<Tacka> omotac;

    for (int i = 0; i < n; i++) {
        while (omotac.size() >= 2 && proizvod(omotac.back() - omotac[omotac.size() - 2], tacke[i] - omotac[omotac.size() - 2]) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }

    size_t donjaDuzina = omotac.size();
    for (int i = n - 2; i >= 0; i--) {
        while (omotac.size() > donjaDuzina && proizvod(omotac.back() - omotac[omotac.size() - 2], tacke[i] - omotac[omotac.size() - 2]) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }

    omotac.pop_back(); 
    return omotac;
}

int main() 
{
    ios_base::sync_with_stdio(0);
    cin.tie(0); cout.tie(0);
    
    int n;
    cin >> n;

    vector<Tacka> tacke(n);

    for (int i = 0; i < n; i++) 
        cin >> tacke[i].x >> tacke[i].y;

    sort(tacke.begin(), tacke.end());

    double povrsina = 1e18;
    vector<Tacka> trenutneTacke;

    for (int t = 0; t < n; t++) 
    {
        trenutneTacke.clear();
        for (int i = 0; i < n; i++) if (i != t) trenutneTacke.push_back(tacke[i]);
        vector<Tacka> omotac = konveksniOmotac(trenutneTacke);
        povrsina = min(povrsina, Povrsina(omotac));
    }

    cout << fixed << setprecision(0) << povrsina;

    return 0;
}